/* Scanner for gcl */

%{
#include <string.h>
#include "gcl2pl.h"
#include "y.tab.h"	/* Tokens definitions generated by yacc (option -d)*/

extern int yyerror(char *);
%}
%option noyywrap
%array

DIGIT    [0-9]
ID       [a-z][a-zA-Z0-9_]*
VID      [A-Z][a-zA-Z0-9_]*
STRING   "\""[^\"]*"\""

%%

abort		{ return ABORT; }
and		{ return AND; }
boolean		{ return BOOLEAN; }
cand		{ return CAND; }
char		{ return CHAR; }
const		{ return CONST; }
cor		{ return COR; }
do		{ return DO; }
if		{ return IF; }
integer		{ return INTEGER; }
false		{ return FALSE; }
fn	        { return FN; }
fi		{ return FI; }
mod		{ return MOD; }
nf              { return NF; }
not		{ return NOT; }
od		{ return OD; }
or		{ return OR; }
skip		{ return SKIP; }
true		{ return TRUE; }

".."		{ return DOTS; }
":="		{ return ASSIGN; }
"->"		{ return ARROW;}

">="		{ return GEQ; }	
"<="		{ return LEQ; }	
"<>"		{ return NEQ; }	


{DIGIT}+	{ yylval.strval=strCopy(yytext); return NUMBER; }
{ID}		{ yylval.strval=strCopy(yytext); return ID; }
{VID}		{ yylval.strval=strCopy(yytext); return VID; }
{STRING}	{ int len=strlen(yytext)-2;
                  yylval.strval = (char *) malloc(len+1);
		  yylval.strval[len]='\0';
		  if (len)		  		  
  		    strncpy(yylval.strval,yytext+1,len);
		  return STRING;}

"/*"([^*]|"*"[^/])*"*/"	{
		 char *s;
		 for (s=yytext;(s=strchr(s,'\n'))!=NULL; s++,yyline++);
		}
"//"[^\n]*	{} /* eat up one-line comments */

[ \t\r]+	/* eat up whitespace */
\n		{yyline++;}
.           	{return yytext[0];}

%%
