%{
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "gcl2pl.h"

extern int yylex(void);
extern int yyrestart(FILE *);
int yyerror (char *s)  /* Called by yyparse on error */
{
  fprintf (stderr,"%d: %s after `%s'\n", yyline, s, yytext);
  return 1;
}

%}

%union {
char  	*strval; /* For returning a string */
}


%token ABORT
%token AND
%token BOOLEAN
%token CAND
%token CHAR
%token COR
%token CONST
%token DO
%token IF
%token INTEGER
%token FALSE
%token FN
%token FI
%token MOD
%token NF
%token NOT
%token OD
%token OR
%token SKIP
%token TRUE

%token DOTS
%token ASSIGN
%token ARROW
%token GEQ
%token LEQ
%token NEQ

%token  NUMBER     /* integer   */
%token  ID         /* identifier */
%token  VID        /* variable identifier */
%token  STRING     /* string literal */

%type <strval> annot_sentence
%type <strval> arg
%type <strval> args
%type <strval> assertion
%type <strval> branches
%type <strval> branch
%type <strval> constant
%type <strval> exps
%type <strval> exp
%type <strval> id
%type <strval> initial
%type <strval> lvars
%type <strval> lvar
%type <strval> number
%type <strval> sentence
%type <strval> sentences
%type <strval> string
%type <strval> type

%left OR COR
%left AND CAND
%left NOT
%left PREV
%right '=' LEQ GEQ NEQ '>' '<'
%left '-' '+'
%left '*' '/' MOD
%left UMINUS     /* unary minus */

/* Grammar follows */

%%

program : 
    declarations ';' sentences 	{printf("program([\n%s\n]).\n",$3);};
  | sentences			{printf("program([\n%s\n]).\n",$1);};

declarations :  
    declaration
  | declarations ';' declaration 
  ;
  
sentences :    
    annot_sentence 			{$$=$1;}
  | sentences ';' annot_sentence 	{$$=strCat($1,",\n",$3,NULL);}
  ;

declaration :
    id ':' type initial	{printf("vardecl(%s,%s,[%s]).\n",$1,$3,$4);}
  | id '[' exp ':' exp ']' ':' type initial
  	{ printf("vardecl(%s,array(%s,%s,%s),[%s]).\n",$1,$3,$5,$8,$9); }
  | FN id '(' args ')' ':' type sentences NF
        { printf("fndecl(%s,%s,[%s],[%s]).\n",$2,$7,$4,$8);}
  | FN id '(' ')' ':' type sentences NF
        { printf("fndecl(%s,%s,[],[%s]).\n",$2,$6,$7);}
  | CONST constant '=' exp
        { printf("constdecl('%s',%s).\n",$2,$4); }
  ;  

args :
    arg                 {$$=$1;}
  | args ';' arg        {$$=strCat($1,",",$3,NULL);}
  ;

arg :
    id                  {$$=strCat($1,":integer",NULL);}
  | id ':' type         {$$=strCat($1,":",$3,NULL);}
  ;

type :
    BOOLEAN		{$$="boolean";}
  | CHAR		{$$="char";}
  | INTEGER		{$$="integer";}
  ;

initial : 
    '=' '(' exps ')'	{$$=strCat("[",$3,"]",NULL);}
  | '=' string		{$$=strCat("\"",$2,"\"",NULL);}
  | exp			{$$=$1;}
|			{$$="";}
  ;

id : ID 		{ $$=yylval.strval; } ;
number : NUMBER 	{ $$=yylval.strval; } ;
string : STRING		{ $$=yylval.strval; } ;
constant : VID 		{ $$=yylval.strval; } ;

annot_sentence:	
    sentence 				{$$=$1;}
  | assertion sentence			{$$=strCat($1,",",$2,NULL);}
  | sentence assertion 			{$$=strCat($1,",",$2,NULL);}
  | assertion sentence assertion	{$$=strCat($1,",",$2,",",$3,NULL);}
  ;

assertion : 		
			{assignline=yyline;}
    '{' exp '}'		{ $$=malloc(20);
    			  sprintf($$,"%d",assignline);
    			  $$=strCat("assert(",$$,",", $3, ")", NULL );
			}
  ;

sentence :
    SKIP		{$$="skip";}
  | ABORT		{$$="abort";}
  | lvars 		{ assignline=yyline; }
    ASSIGN exps 	{ $$=malloc(20);
    			  sprintf($$,"%d",assignline);
    			  $$=strCat("(",$$,":[", $1, "] := [", $4, "])", NULL );
			}
  | IF branches FI	{$$=strCat("if([", $2, "])", NULL );}
  | DO branches OD	{$$=strCat("do([", $2, "])", NULL );}
  ;

branches : 
    branch		{$$=$1;}
  | branches '|' branch	{$$=strCat($1,",",$3,NULL);}
  ;
  
branch : exp ARROW sentences {$$=strCat($1,"-> [",$3,"]",NULL);} ;

lvars : 
    lvar 		{$$=$1;}
  | lvars ',' lvar 	{$$=strCat($1,",",$3,NULL);}
  ;

lvar : 
    id  		{ $$=strCat("id(",$1,")",NULL);	}
  | id '[' exps ']'	{$$=strCat("arr(",$1,",[",$3,"])",NULL);}
  ;

exps : 
    exp 		{$$=$1;}
  | exps ',' exp 	{$$=strCat($1,",",$3,NULL);}
  ;

exp :
    '(' exp ')'		{$$=$2;}
  | number		{$$=$1;}
  | TRUE		{$$="true";}  
  | FALSE		{$$="false";}  
  | lvar		{$$=$1;}  
  | constant		{$$=strCat("constant('",$1,"')",NULL);}

  | id '(' exps ')'     {$$=strCat("call(",$1,",[",$3,"])",NULL);}
  | id '('  ')'         {$$=strCat("call(",$1,",[])",NULL);}

  | exp AND exp		{$$=strCat("and(",$1,",",$3,")",NULL);}
  | exp OR exp		{$$=strCat("or(",$1,",",$3,")",NULL);}
  | exp CAND exp	{$$=strCat("cand(",$1,",",$3,")",NULL);}
  | exp COR exp		{$$=strCat("cor(",$1,",",$3,")",NULL);}
  | NOT exp		{$$=strCat("not(",$2,")",NULL);}
  
  | exp '=' exp		{$$=strCat("eq(",$1,",",$3,")",NULL);}
  | exp '>' exp		{$$=strCat("gt(",$1,",",$3,")",NULL);}
  | exp '<' exp		{$$=strCat("lt(",$1,",",$3,")",NULL);}
  | exp GEQ exp		{$$=strCat("geq(",$1,",",$3,")",NULL);}
  | exp LEQ exp		{$$=strCat("leq(",$1,",",$3,")",NULL);}
  | exp NEQ exp		{$$=strCat("neq(",$1,",",$3,")",NULL);}
  
  | exp '+' exp		{$$=strCat("plus(",$1,",",$3,")",NULL);}
  | exp '-' exp		{$$=strCat("minus(",$1,",",$3,")",NULL);}
  | exp '*' exp		{$$=strCat("times(",$1,",",$3,")",NULL);}
  | exp '/' exp		{$$=strCat("div(",$1,",",$3,")",NULL);}
  | exp MOD exp		{$$=strCat("mod(",$1,",",$3,")",NULL);}

  | '-' exp  %prec UMINUS  {$$=strCat("-",$2,NULL);}
  
  ;
  

/* End of grammar */
%%
