#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "gcl2pl.h"
int yyparse();

unsigned int yyline;
unsigned int assignline=0;
char *defAttrType;
char *strCat(const char *s, ... ) {
  va_list ap;
  char *t=NULL;
  
  va_start(ap, s);
  while (s) {
    if (!t) {
      int size = strlen(s)+1;
      t=(char*)malloc(size);
      memcpy(t,s,size);
    }
    else {
      char *r=(char *)malloc(strlen(s)+strlen(t)+1);
      sprintf(r,"%s%s",t,s);
      free(t);
      t=r;
    }
    s = va_arg(ap, const char *);
  }
  va_end(ap);
  return t;
}

char *strCopy(char *s)
{
  int size;
  char *t;
  
  size=strlen(s)+1;
  if( (t=(char *)malloc(sizeof(char)*size)) == NULL)
  {
    printf("NULL malloc: cloning string %s\n",s);
    exit(0);
  }
  memcpy(t,s,size);
  return t;
}

char *strAppend(char *s,char *t)
{
  char *r=(char *)malloc(strlen(s)+strlen(t)+1);
  sprintf(r,"%s%s",s,t);
  free(s);
  return r;
}


int main() {
  yyparse();
}
